/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeIterator;
import icyllis.flexmark.util.collection.iteration.ReversibleIterator;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterable;
import icyllis.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.function.Consumer;

public class NodeIterable
implements ReversiblePeekingIterable<Node> {
    final Node firstNode;
    final Node lastNode;
    final boolean reversed;
    public static final ReversiblePeekingIterable<Node> EMPTY = new ReversiblePeekingIterable<Node>(){

        @Override
        @NotNull
        public ReversiblePeekingIterator<Node> iterator() {
            return NodeIterator.EMPTY;
        }

        @Override
        @NotNull
        public ReversiblePeekingIterable<Node> reversed() {
            return this;
        }

        @Override
        public void forEach(Consumer<? super Node> consumer) {
        }

        @Override
        public boolean isReversed() {
            return false;
        }

        @Override
        @NotNull
        public ReversiblePeekingIterator<Node> reversedIterator() {
            return NodeIterator.EMPTY;
        }
    };

    public NodeIterable(Node firstNode, Node lastNode, boolean reversed) {
        this.firstNode = firstNode;
        this.lastNode = lastNode;
        this.reversed = reversed;
    }

    @Override
    @NotNull
    public ReversiblePeekingIterator<Node> iterator() {
        return new NodeIterator(this.firstNode, this.lastNode, this.reversed);
    }

    @Override
    public void forEach(Consumer<? super Node> consumer) {
        ReversibleIterator iterator = this.iterator();
        while (iterator.hasNext()) {
            consumer.accept((Node)iterator.next());
        }
    }

    @Override
    @NotNull
    public ReversiblePeekingIterable<Node> reversed() {
        return new NodeIterable(this.firstNode, this.lastNode, !this.reversed);
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    @NotNull
    public ReversiblePeekingIterator<Node> reversedIterator() {
        return new NodeIterator(this.firstNode, this.lastNode, !this.reversed);
    }
}

